unit MiscU;

interface

uses
  Androidapi.JNIBridge;

//Make a string by concatenating together all hex values of each byte
function JavaBytesToString(JavaBytes: TJavaArray<Byte>; Separator: string = '-'): string;
//Make a string by concatenating together the characters represented by each byte
function JavaBytesToText(JavaBytes: TJavaArray<Byte>): string;
//Make a raw block of memory that is the same as the Java bytes array we are given
function JavaBytesToBytes(JavaBytes: TJavaArray<Byte>): PByte;
function BytesToJavaBytes(Bytes: PByte; BytesLen: Integer): TJavaArray<Byte>;

implementation

uses
  System.SysUtils,
  Androidapi.Jni;

function JavaBytesToString(JavaBytes: TJavaArray<Byte>; Separator: string = '-'): string;
var
  I: Integer;
begin
  if JavaBytes <> nil then
    for I := 0 to Pred(JavaBytes.Length) do
    begin
      Result := Result + IntToHex(JavaBytes.Items[I], 2);
      if (I < Pred(JavaBytes.Length)) and (Separator.Length > 0) then
        Result := Result + '-';
    end;
end;

function JavaBytesToText(JavaBytes: TJavaArray<Byte>): string;
var
  I: Integer;
begin
  for I := 0 to Pred(JavaBytes.Length) do
  begin
    Result := Result + Char(JavaBytes.Items[I]);
  end;
end;

function JavaBytesToBytes(JavaBytes: TJavaArray<Byte>): PByte;
//var
//  I: Integer;
//  Rover: PByte;
begin
  GetMem(Result, JavaBytes.Length);
//  Rover := Result;
//  for I := 0 to Pred(JavaBytes.Length) do
//  begin
//    Rover^ := JavaBytes.Items[I];
//    Inc(Rover);
//  end;
  Move(JavaBytes.Data^, Result^, JavaBytes.Length)
end;

function BytesToJavaBytes(Bytes: PByte; BytesLen: Integer): TJavaArray<Byte>;
begin
  Result := TJavaArray<Byte>.Create(BytesLen);
  Move(Bytes^, Result.Data^, BytesLen);
end;

end.
